/****** Object:  View [dbo].[V_EST_PROD]    Script Date: 27/06/2016 11:34:47 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PROD]'))
DROP VIEW [dbo].[V_EST_PROD]
GO


CREATE VIEW [dbo].[V_EST_PROD]
AS
SELECT
		EST_PROD.CD_EMP
		,EST_PROD.CD_PROD
		,EST_PROD.CD_FILIAL
		,EST_PROD.DS_PROD
		,EST_PROD.DS_USUAL
		,EST_PROD.APRES_EMB_VD
		,EST_PROD.APRES_QT_CP
		,EST_PROD.APRES_QT_VD
		,EST_PROD.PESO_PROD_CP
		,EST_PROD.PESO_PROD_VD
		,EST_PROD.DT_CAD
		,EST_PROD.CD_USU
		,ISNULL(EST_PROD.DT_ULT_ATU, EST_PROD.DT_CAD)          AS DT_ULT_ATU
		,EST_PROD.CD_MC
		,A.DS_MC
		,EST_PROD.CD_APLIC
		,EST_PROD.CD_CLASS_FISC
		,A.DS_CLASS_FISC
		,EST_PROD.CD_UN_VD
		,EST_PROD.CD_UN_CP
		,EST_PROD.TP_EXPL
		,EST_PROD.GERA_BLNC
		,EST_PROD.DIA_VLD
		,EST_PROD.PERC_COMIS
		,EST_PROD.PERC_DESC
		,EST_PROD.PLU_PROD
		,EST_PROD.PIS_COFINS
		,EST_PROD.PERC_MARGEM
		,EST_PROD.GERA_ETQ_RES
		,EST_PROD.CD_FABRIC
		,B.NM_FABRIC
		,EST_PROD.VLR_CUSTO_GRP
		,EST_PROD.VLR_COMPRA_GRP
		,EST_PROD.STS_PROD
		,EST_PROD.LISTA_PROD
		,EST_PROD.OBS_PROD
		,EST_PROD.PERC_DESC_FIX
		,EST_PROD.QTDE_LITRO
		,EST_PROD.PERC_COMIS_INTERNO
		,EST_PROD.CTR_LOTE
		,EST_PROD.CTR_PMC
		,EST_PROD.NR_NCM
		,EST_PROD.PERC_COMIS_DESC_INT
		,EST_PROD.PERC_COMIS_DESC_EXT
		,EST_PROD.PERC_DESC_FIDEL
		,EST_PROD.STS_PROD_CALL_CENTER
		,EST_PROD.COMPRA_POR_SUPRIMENTO
		,EST_PROD.PERC_DESC_FIDEL_MAX
		,EST_PROD.PROMO_INDUSTRIA
		,EST_PROD.PERC_DESC_FINAN
		,ISNULL(EST_PROD.PERC_MARGEM_FIXA, 0)                  AS PERC_MARGEM_FIXA
		,ISNULL(EST_PROD.VLR_PRECO_FIXO, 0)                    AS VLR_PRECO_FIXO
		,EST_PROD.DT_PRECO_FIXO
		,ISNULL(EST_PROD.DS_MOTIVO_VLR_LISTA, '')              AS DS_MOTIVO_VLR_LISTA
		,EST_PROD.FLAG_ANALISE_FALTAS
		,EST_PROD.FLAG_VERBA_DESCON
		,EST_PROD.FLAG_PROMO_FORN
		,EST_PROD.VLR_PRECO_OPERADOR_LOG
		,EST_PROD.QT_UNI_RESSUPRIMENTO
		,EST_PROD.PROD_LIBERADO
		,EST_PROD.PROD_USO_CONT
		,EST_PROD.FLAG_REQUER_RECEIT
		,EST_PROD.FLAG_ALTERAR_PRECO
		,EST_PROD.FLAG_PROD_KIT
		,EST_PROD.FLAG_ANALISE_EXC_COB
		,EST_PROD.FLAG_COMPRA_PHARMALINK
		,ISNULL(EST_PROD.CLASSE_TERAPEUTICA, '')               AS CLASSE_TERAPEUTICA
		,EST_PROD.FLAG_PRODUTO_CONTROLADO
		,EST_PROD.FLAG_PRODUTO_COTACAO
		,EST_PROD.VLR_COMISSAO_FABRIC
		,EST_PROD.FLAG_VENDA_PERIODICA
		,EST_PROD.FLAG_VENDA_CONSIGNADA
		,EST_PROD.FLAG_IGNORAR_PMC_SUBST
		,EST_PROD.FLAG_DESCONTO_TICKET_BLQ
		,EST_PROD.PERC_DESC_LIMITE
		,EST_PROD.FLAG_PRODUTO_BLISTER
		,EST_PROD.FLAG_PRODUTO_GENERICO
		,EST_PROD.FLAG_PRODUTO_TAXA_ENTREGA
		,EST_PROD.FLAG_VD_CALL_CENTER
		,EST_PROD.FRACAO_ABC_FARMA
		,EST_PROD.FLAG_NAO_APARECER_ESTATISTICA_COMPRA_CLIENTE
		,ISNULL(EST_PROD.COMPRIMENTO, 0)                       AS COMPRIMENTO
		,ISNULL(EST_PROD.LARGURA, 0)                           AS LARGURA
		,ISNULL(EST_PROD.ALTURA, 0)                            AS ALTURA
		,EST_PROD.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
		,ISNULL(EST_PROD.QTDE_CAIXA, 0)                        AS QTDE_CAIXA
		,EST_PROD.FLAG_TROCA_FORNECEDOR
		,EST_PROD.FLAG_NAO_PERMITIR_DEVOLUCAO
		,ISNULL(EST_PROD.PERC_ALIQ_REA_ESTADUAL, 0)            AS PERC_ALIQ_REA_ESTADUAL
		,ISNULL(EST_PROD.PERC_ALIQ_REA_INTERESTADUAL, 0)       AS PERC_ALIQ_REA_INTERESTADUAL
		,ISNULL(EST_PROD.NR_ITEM_REA, 0)                       AS NR_ITEM_REA
		,EST_PROD.PERC_COMIS_SERVICO
		,ISNULL(EST_PROD.NR_REG_MS, '')                        AS NR_REG_MS
		,EST_PROD.FLAG_NAO_ANALISAR_CUSTO
		,ISNULL(EST_PROD.FLAG_REQUER_RECEITA, 0)               AS FLAG_REQUER_RECEITA
		,ISNULL(EST_PROD.FLAG_PROD_DESPESA_ACES, 0)            AS FLAG_PROD_DESPESA_ACES
		,ISNULL(EST_PROD.FLAG_NAO_CREDITAR_IMPOSTO, 0)         AS FLAG_NAO_CREDITAR_IMPOSTO
		,EST_PROD.UMM
		,ISNULL(EST_PROD.CD_TP_RECEITA, 0)                     AS CD_TP_RECEITA
		,ISNULL(D.DS_TP_RECEITA, 'NAO DEFINIDO')               AS DS_TP_RECEITA
		,ISNULL(EST_PROD.CD_COR_RECEITA, 0)                    AS CD_COR_RECEITA
		,ISNULL(C.DS_COR, 'NAO DEFINIDO')                      AS DS_COR
		,ISNULL(EST_PROD.FLAG_NAO_FACEAR_AUTOMATICO, 0)        AS FLAG_NAO_FACEAR_AUTOMATICO
		,EST_PROD.QT_EMB_FECHADA_CP
		,EST_PROD.QT_EMB_ALTERNATIVA_CP
		,ISNULL(EST_PROD.QT_MES_VALID, 0)                      AS QT_MES_VALID
		,ISNULL(EST_PROD.FLAG_PRODUTO_SIMILAR, 0)              AS FLAG_PRODUTO_SIMILAR
		,ISNULL(EST_PROD.FLAG_PRODUTO_ETICO, 0)                AS FLAG_PRODUTO_ETICO
		,ISNULL(EST_PROD.ANTIBIOTICO, 0)                       AS ANTIBIOTICO
		,EST_PROD.CONTROLE_SNGPC
		,ISNULL(EST_PROD.TERMO_LABEL, 0)                       AS TERMO_LABEL
		,EST_PROD.TP_UND_FARMACOTECNICA
		,EST_PROD.TP_UND_ANVISA
		,EST_PROD.TP_CLASS_ANVISA
		,EST_PROD.DADOS_CPL_PACIENTE
		,ISNULL(EST_PROD.RECEITA_FLAG_TIPO_OBRIGATOREIDADE, 0) AS RECEITA_FLAG_TIPO_OBRIGATOREIDADE
		,EST_PROD.ORIGEM_PRODUTO
		,EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS
		,EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA
		,EST_PROD.TP_SERV_PROD
		,EST_PROD.FLAG_EXCECAO_PIS_COFINS
		,EST_PROD.SIGLA_EXCECAO_PIS_COFINS
		,EST_PROD.FLAG_TRIB_PIS_COFINS_PROD
		,EST_PROD.CD_CST_PIS_SAIDA
		,EST_PROD.CD_CST_COFINS_SAIDA
		,EST_PROD.CD_CST_PIS_ENTRADA
		,EST_PROD.CD_CST_COFINS_ENTRADA
		,EST_PROD.VLR_PRECO_FRANQUIA
		,EST_PROD.FLAG_PROD_CESTA_BASICA
		,EST_PROD.FLAG_RESSARCIMENTO
		,EST_PROD.FLAG_ADJUDICACAO
		,ISNULL(EST_PROD.FLAG_DIRETO_PDV, 0)				   AS FLAG_DIRETO_PDV
		,EST_PROD.QTDE_DIAS_TRATAMENTO_PROD
		,EST_PROD.VLR_FABRICA
		,EST_PROD.PERC_DESC_FABRICA
		,EST_PROD.FLAG_PERMITE_RESSARCIMENTO_ICMS
		,EST_PROD.APRES_EMB_CP
		,ISNULL(A.CD_ARV_MERC_CATEG, 0)                        ASCD_ARV_MERC_CATEG
		,ISNULL(A.DS_ARV_MERC_CATEG, 'NAO DEFINIDO')           AS DS_ARV_MERC_CATEG
		,ISNULL(A.CD_ARV_MERC_SEG, 0)                          AS CD_ARV_MERC_SEG
		,ISNULL(A.DS_ARV_MERC_SEG, 'NAO DEFINIDO')             AS DS_ARV_MERC_SEG
		,ISNULL(A.CD_ARV_MERC_PAPEL, 0)                        AS CD_ARV_MERC_PAPEL
		,ISNULL(A.DS_ARV_MERC_PAPEL, 'NAO DEFINIDO')           AS DS_ARV_MERC_PAPEL
		,ISNULL(A.CD_ARV_MERC_MIX, 0)                          AS CD_ARV_MERC_MIX
		,ISNULL(A.DS_ARV_MERC_MIX, 'NAO DEFINIDO')             AS DS_ARV_MERC_MIX
		,ISNULL(A.CD_ARV_MERC_CONSUMO, 0)                      AS CD_ARV_MERC_CONSUMO
		,ISNULL(A.DS_ARV_MERC_CONSUMO, 'NAO DEFINIDO')         AS DS_ARV_MERC_CONSUMO
		,ISNULL(A.CD_ARV_MERC_LINHA, 0)                        AS CD_ARV_MERC_LINHA
		,ISNULL(A.DS_ARV_MERC_LINHA, 'NAO DEFINIDO')           AS DS_ARV_MERC_LINHA
		,ISNULL(A.CD_ARV_MERC_MTZ_BCG, 0)                      AS CD_ARV_MERC_MTZ_BCG
		,ISNULL(A.DS_ARV_MERC_MTZ_BCG, 'NAO DEFINIDO')         AS DS_ARV_MERC_MTZ_BCG
		,ISNULL(A.CD_ARV_MERC_FAMILIA, 0)                      AS CD_ARV_MERC_FAMILIA
		,ISNULL(A.DS_ARV_MERC_FAMILIA, 'NAO DEFINIDO')         AS DS_ARV_MERC_FAMILIA
		,ISNULL(A.CD_ARV_MERC_DEPTO, 0)                        AS CD_ARV_MERC_DEPTO
		,ISNULL(A.DS_ARV_MERC_DEPTO, 'NAO DEFINIDO')           AS DS_ARV_MERC_DEPTO
		,ISNULL(A.CD_APRES, 0)                                 AS CD_APRES
		,ISNULL(A.DS_APRES, 'NAO DEFINIDO')                    AS DS_APRES
		,ISNULL(A.CD_ARV_MERC_EQUI, 0)                         AS CD_ARV_MERC_EQUI
		,ISNULL(A.DS_ARV_MERC_EQUI, 'NAO DEFINIDO')            AS DS_ARV_MERC_EQUI
		,ISNULL(A.CD_GRP_EXPO, 0)                              AS CD_GRP_EXPO
		,ISNULL(A.DS_GRP_EXPO, 'NAO DEFINIDO')                 AS DS_GRP_EXPO
		,ISNULL(A.CD_ARV_MERC_CLASSIFICACAO, 0)                AS CD_ARV_MERC_CLASSIFICACAO
		,ISNULL(A.DS_ARV_MERC_CLASSIFICACAO, 'NAO DEFINIDO')   AS DS_ARV_MERC_CLASSIFICACAO
		,ISNULL(A.CD_ARV_MERC_FASE, 0)                         AS CD_ARV_MERC_FASE
		,ISNULL(A.DS_FASE, 'NAO DEFINIDO')                     AS DS_FASE
		,ISNULL(A.CD_ARV_MERC_GENERO, 0)                       AS CD_ARV_MERC_GENERO
		,ISNULL(A.DS_GENERO, 'NAO DEFINIDO')                   AS DS_GENERO
		,ISNULL(A.CD_ARV_MERC_AREA_ATEND, 0)                   AS CD_ARV_MERC_AREA_ATEND
		,ISNULL(A.DS_ARV_MERC_AREA_ATEND, 'NAO DEFINIDO')      AS DS_ARV_MERC_AREA_ATEND
		,ISNULL(GLB_OPER_CEL.CD_OPER_CEL, 0)                   AS CD_OPER_CEL
		,ISNULL(GLB_OPER_CEL.NM_OPER_CEL, '')                  AS NM_OPER_CEL
		,ISNULL(GLB_OPER_CEL.NR_OPER_CEL, 0)                   AS NR_OPER_CEL
		,ISNULL(GLB_OPER_CEL.CD_FORN, 0)                       AS CD_FORN
		,E.CD_BARRA
		,ISNULL(EST_PROD.NR_CEST, '')                          NR_CEST
		,EST_PROD.NR_NCM                                       AS NCM_PROD
		,ISNULL(EST_PROD.nr_serv, '')						   AS NR_SERV
	FROM
		EST_PROD
		LEFT JOIN V_EST_PROD_ARV_MERCADOLOGICA A ON
			EST_PROD.CD_EMP = A.CD_EMP AND
			EST_PROD.CD_PROD = A.CD_PROD
		LEFT OUTER JOIN GLB_OPER_CEL ON
			EST_PROD.CD_EMP = GLB_OPER_CEL.CD_EMP AND
			EST_PROD.CD_PROD = GLB_OPER_CEL.CD_PROD
		LEFT JOIN EST_PROD_FABRIC B ON
			EST_PROD.CD_FABRIC = B.CD_FABRIC
		LEFT JOIN GLB_COR_RECEITA C ON
			EST_PROD.CD_COR_RECEITA = C.CD_COR
		LEFT JOIN GLB_TP_RECEITA D ON
			EST_PROD.CD_TP_RECEITA = D.CD_TP_RECEITA
		LEFT JOIN EST_PROD_CD_BARRA E ON
			EST_PROD.CD_PROD = E.CD_PROD AND
			EST_PROD.CD_EMP = E.CD_EMP

GO


